/********************* CONSTANTS *****************************************/
$GENDER_BOTH = 0;
$GENDER_MALE = 1;
$GENDER_FEMALE = 2;

/******************** BASE DATABLOCK CHARACTER TYPES *********************/

// this is a female character that does not modify people resources
datablock CCmpCharacterData(FemaleNotTownsfolkData)
{
   gender = $GENDER_FEMALE;   
   canDrink    = false;
   canWork     = false;
   canQuickJob = false;
};

// this is a male character that does not modify people resources
datablock CCmpCharacterData(MaleNotTownsfolkData)
{
   gender = $GENDER_MALE;
   canDrink    = false;
   canWork     = false;
   canQuickJob = false;
};

// sets up happiness changes for tough male characters
datablock CCmpCharacterData(ToughMaleCharacterData : MaleNotTownsfolkData)
{
   initHappiness = -5;
};

// sets up happiness changes for nice male characters
datablock CCmpCharacterData(NiceMaleCharacterData : MaleNotTownsfolkData)
{
   initHappiness = 5;
};

// if a lawman does not change happiness (deputies)
datablock CCmpCharacterData(LawmanData : MaleNotTownsfolkData)
{
   canReformDrunk = true;
};

// for the tough sheriff
datablock CCmpCharacterData(ToughLawmanData : ToughMaleCharacterData)
{
   canReformDrunk = true;
};

// for the nice sheriff
datablock CCmpCharacterData(NiceLawmanData : NiceMaleCharacterData)
{
   canReformDrunk = true;
};

// base character information regarding how resources will be changed
// for every character that is created
datablock CCmpCharacterData(BaseTownsfolkData)
{
   initWater = 0;
   initFood = 0;
   initPeople = 1;
   
   consumeTime = 30;
   consumeWater = 0;
   consumeFood = 1;
   
   produceTime = 0;
   
   hungerLoss = 1;
   hungerMax = 3;
   drunkHappiness    = 2;
   joblessHappiness  = 1;
   homelessHappiness = 1;
   
   canWork = true;
   canQuickJob = true;
};

// all female characters are derived from this data
datablock CCmpCharacterData(FemaleCharacterData : BaseTownsfolkData)
{
   gender = $GENDER_FEMALE;
};

// all male characters are derived from this data
datablock CCmpCharacterData(MaleCharacterData : BaseTownsfolkData)
{
   gender = $GENDER_MALE;
};

// all female *HERO* characters are derived from this data
datablock CCmpCharacterData(HeroFemaleCharacterData : BaseTownsfolkData)
{
   gender = $GENDER_FEMALE;
   initPeople = 0;
   
   canWork = false;
   isHero  = true;
};

// all male *HERO* characters are derived from this data
datablock CCmpCharacterData(HeroMaleCharacterData : BaseTownsfolkData)
{
   gender = $GENDER_MALE;
   initPeople = 0;
   
   canWork = false;
   isHero  = true;
};

/*********************** BASE DATABLOCK AI TYPES *************************/

datablock CCmpAIData(BaseAIData)
{
   aicmp = "com_settler";
   idleChance = 50;
   speed = 7.5;
   
   // Jobless times until next cycles (5 times needed)
   joblessWaitTimes_0       = "60";
   joblessWaitTimes_1       = "60";
   joblessWaitTimes_2       = "30";
   joblessWaitTimes_3       = "60";
   joblessWaitTimes_4       = "60";
   
   // Jobless percentages and happy modifiers for percentages
   joblessDrunkPercent      = "25 50";
   joblessProtestPercent    = "0 0";
   joblessDrunkHappyMod     = "0 -5 -10 -15 -20";
   joblessProtestHappyMod   = "0 -5 -10 -15 -20";
   
   // Homeless times until next cycles (5 times needed)
   homelessWaitTimes_0      = "60";
   homelessWaitTimes_1      = "60";
   homelessWaitTimes_2      = "60";
   homelessWaitTimes_3      = "30";
   homelessWaitTimes_4      = "30";
   
   // Homeless percentages and happy modifiers for percentages
   homelessDrunkPercent     = "35";
   homelessLeavePercent     = "50";
   homelessProtestPercent   = "100 100";
   homelessDrunkHappyMod    = "0 -5 -10 -15 -20";
   homelessLeaveHappyMod    = "0 -5 -10 -15 -20";
   homelessProtestHappyMod  = "0 -5 -10 -15 -20";
   
   // Hunger times until next cycles (4 times needed)
   hungerWaitTimes_0        = "60";
   hungerWaitTimes_1        = "60";
   hungerWaitTimes_2        = "60";
   hungerWaitTimes_3        = "60";
   
   // Hunger leave percentages and happy modifiers for percentages
   hungerLeavePercent       = "50 50";
   hungerLeaveHappyMod      = "0 -5 -10 -15 -20";
   
   // Time to wait until next protest animation check
   protestAnimTime          = "14";
   protestAnimPercent       = "100";
   protestAnimAngle         = "270";
   
   // Min time to idle when protesting
   protestIdleMinTime       = "2";
   // Max time to idle when protesting
   protestIdleMaxTime       = "5";
   protestWalkRange         = "18";
};

datablock CCmpAIData(HeroAIData)
{
   aicmp = "com_hero";
   idleChance = 40;
   speed = 8.5;
};

datablock CCmpAIData(CombatAIData)
{
   aicmp = "com_combat";
   idleChance = 60;
   speed = 8.2;
};

datablock CCmpAIData(CombatFastAIData)
{
   aicmp = "com_combat";
   idleChance = 70;
   speed = 9.5;
};

datablock CCmpAIData(TimidAnimalAIData)
{
   aicmp = "com_animal_timid";
   idleChance = 60;
   speed = 6;
};

datablock CCmpAIData(BanditAIData)
{
   aicmp = "com_bandit";
   idleChance = 50;
   speed = 7.5;
};

/********************* COMBAT DATABLOCKS ********************************/
datablock CCmpCombatData(CombatData)
{
   weaponRange = 14;
   weaponStrength = 30;
   weaponAccuracy = 0.7;
   
   armorRating = 2;
   rateOfFire = 2;
   
   weaponStrengthMod = 1.0;
   weaponRangeMod = 1.0;
   weaponAccuracyMod = 1.0;
   armorMod = 1.0;
   rofMod = 1.0;
   
   threatRadius = 18;

   weaponL = "shotgun";
   
   audioList = "gunshot : gun_shotgun0";
   audioList = "ricochet : gun_ricochet1";
};

datablock CCmpCombatData(CombatData_GunslingerMale)
{
   weaponRange = 13;
   weaponStrength = 8;
   weaponAccuracy = 0.6;
   
   armorRating = 2;
   rateOfFire = 0.4;
   
   maxWeaponAccuracy = 1.0;
   
   weaponStrengthMod = 1.0;
   weaponRangeMod = 1.0;
   weaponAccuracyMod = 1.0;
   armorMod = 1.0;
   rofMod = 1.0;
   
   threatRadius = 18;

   weaponL = "Revolver2";
   weaponR = "Revolver";
   
   audioList = "gunshot : gun_revolver0";
   audioList = "ricochet : gun_ricochet1";
};

datablock CCmpCombatData(CombatData_Bear)
{
   weaponRange = 4.5;
   weaponStrength = 15;
   weaponAccuracy = 0.9;
   
   armorRating = 2;
   rateOfFire = 1;
   
   maxWeaponAccuracy = 1.0;
   
   weaponStrengthMod = 1.0;
   weaponRangeMod = 1.0;
   weaponAccuracyMod = 1.0;
   armorMod = 1.0;
   rofMod = 1.0;
   
   threatRadius = 16;
   
};

datablock CCmpCombatData(CombatData_Sasquatch)
{
   weaponRange = 5;
   weaponStrength = 40;
   weaponAccuracy = 1;
   
   armorRating = 3;
   rateOfFire = 2.5;
   
   maxWeaponAccuracy = 1.0;
   
   weaponStrengthMod = 1.0;
   weaponRangeMod = 1.0;
   weaponAccuracyMod = 1.0;
   armorMod = 1.0;
   rofMod = 1.0;
   
   threatRadius = 17;
   
};

datablock CCmpCombatData(CombatData_GunslingerFemale)
{
   weaponRange = 16;
   weaponStrength = 18;
   weaponAccuracy = 0.9;

   armorRating = 2;
   rateOfFire = 2;

   weaponStrengthMod = 1.0;
   weaponRangeMod = 1.0;
   weaponAccuracyMod = 1.0;
   armorMod = 1.0;
   rofMod = 1.0;

   threatRadius = 19;
   
   weaponR = "Rifle";
   
   audioList = "gunshot : gun_rifle0";
   audioList = "ricochet : gun_ricochet1";
};

datablock CCmpCombatData(CombatData_BanditMale)
{
   weaponRange = 13;
   weaponStrength = 7;
   weaponAccuracy = 0.55;
   
   armorRating = 2;
   rateOfFire = 0.55;
   
   weaponStrengthMod = 1.0;
   weaponRangeMod = 1.0;
   weaponAccuracyMod = 1.0;
   armorMod = 1.0;
   rofMod = 1.0;
   
   threatRadius = 19;
   
   weaponL = "Revolver2";
   weaponR = "Revolver";
   
   audioList = "gunshot : gun_revolver0";
   audioList = "ricochet : gun_ricochet1";
};

datablock CCmpCombatData(CombatData_BanditFemale)
{
   weaponRange = 16;
   weaponStrength = 15;
   weaponAccuracy = 0.8;
   
   armorRating = 2;
   rateOfFire = 2;
   
   weaponStrengthMod = 1.0;
   weaponRangeMod = 1.0;
   weaponAccuracyMod = 1.0;
   armorMod = 1.0;
   rofMod = 1.0;
   
   threatRadius = 19;
   
   weaponL = "rifle";

   audioList = "gunshot : gun_rifle0";
   audioList = "ricochet : gun_ricochet1";
};

datablock CCmpCombatData(CombatData_GunslingerTough)
{
   weaponRange = 14;
   weaponStrength = 10;
   weaponAccuracy = 0.7;
   
   armorRating = 3;
   rateOfFire = 0.5;
   
   weaponStrengthMod = 1.0;
   weaponRangeMod = 1.0;
   weaponAccuracyMod = 1.0;
   armorMod = 1.0;
   rofMod = 1.0;
   
   threatRadius = 19;
   
   weaponL = "Revolver2";
   weaponR = "Revolver";
   
   audioList = "gunshot : gun_revolver0";
   audioList = "ricochet : gun_ricochet1";

   weaponResultStim = "wound 2 true";
};

datablock CCmpCombatData(CombatData_SheriffTough)
{
   weaponRange = 14;
   weaponStrength = 17;
   weaponAccuracy = 0.8;
   
   armorRating = 4;
   rateOfFire = 0.75;
   
   weaponStrengthMod = 1.0;
   weaponRangeMod = 1.0;
   weaponAccuracyMod = 1.0;
   armorMod = 1.0;
   rofMod = 1.0;
   
   threatRadius = 19;
   
   weaponL = "shotgun";
   
   audioList = "gunshot : gun_shotgun0";
   audioList = "ricochet : gun_ricochet1";

   //weaponResultStim = "wound 2 true";
};

datablock CCmpCombatData(CombatData_GunslingerNice)
{
   weaponRange = 13;
   weaponStrength = 8;
   weaponAccuracy = 0.5;
   
   armorRating = 1.5;
   rateOfFire = 0.8;
   
   weaponStrengthMod = 1.0;
   weaponRangeMod = 1.0;
   weaponAccuracyMod = 1.0;
   armorMod = 1.0;
   rofMod = 1.0;
   
   threatRadius = 19;
   
   weaponR = "Revolver";
   
   audioList = "gunshot : gun_revolver0";
   audioList = "ricochet : gun_ricochet1";
};

datablock CCmpCombatData(CombatData_MrWhite)
{
   weaponRange = 13;
   weaponStrength = 15;
   weaponAccuracy = 0.8;
   
   armorRating = 2;
   rateOfFire = 1.4;
   
   weaponStrengthMod = 1.0;
   weaponRangeMod = 1.0;
   weaponAccuracyMod = 1.0;
   armorMod = 1.0;
   rofMod = 1.0;
   
   threatRadius = 18;
   
   weaponR = "Shotgun";
   
   audioList = "gunshot : gun_shotgun0";
   audioList = "ricochet : gun_ricochet1";
};

datablock CCmpCombatData(CombatData_MadRussian)
{
   weaponRange = 15;
   weaponStrength = 16;
   weaponAccuracy = 0.8;
   
   armorRating = 2;
   rateOfFire = 1.4;
   
   weaponStrengthMod = 1.0;
   weaponRangeMod = 1.0;
   weaponAccuracyMod = 1.0;
   armorMod = 1.0;
   rofMod = 1.0;
   
   threatRadius = 19;
   
   weaponR = "rifle";
   
   audioList = "gunshot : gun_revolver0";
   audioList = "ricochet : gun_ricochet1";
};

datablock CCmpCombatData(CombatData_Hunter)
{
   weaponRange = 15;
   weaponStrength = 15;
   weaponAccuracy = 0.8;
   
   armorRating = 2;
   rateOfFire = 1.5;
   
   weaponStrengthMod = 1.0;
   weaponRangeMod = 1.0;
   weaponAccuracyMod = 1.0;
   armorMod = 1.0;
   rofMod = 1.0;
   
   threatRadius = 19;
   
   weaponR = "Musket";
   
   audioList = "gunshot : gun_musket0";
   audioList = "ricochet : gun_ricochet1";
};

datablock CCmpCombatData(CombatData_Banker)
{
   weaponRange = 13;
   weaponStrength = 7;
   weaponAccuracy = 0.7;
   
   armorRating = 2;
   rateOfFire = 0.7;
   
   weaponStrengthMod = 1.0;
   weaponRangeMod = 1.0;
   weaponAccuracyMod = 1.0;
   armorMod = 1.0;
   rofMod = 1.0;
   
   threatRadius = 19;
   
   weaponR = "Dillenger";
   
   audioList = "gunshot : gun_revolver0";
   audioList = "ricochet : gun_ricochet1";
};

datablock CCmpCombatData(CombatData_Animal)
{
   weaponRange = 6;
   weaponStrength = 0;
   weaponAccuracy = 1;
   
   armorRating = 1;
   rateOfFire = 1;
   
   weaponStrengthMod = 1.0;
   weaponRangeMod = 1.0;
   weaponAccuracyMod = 1.0;
   armorMod = 1.0;
   rofMod = 1.0;
   
   weaponR = "";
   
   audioList = "";
   
   threatRadius = 18;
};
/********************* BASE DATABLOCK OBJECT TYPES ***********************/


// set up animations
exec("~/data/shapes/characters/maleciv.cs");
exec("~/data/shapes/characters/femaleciv.cs");
exec("~/data/shapes/characters/farmer.cs");
exec("~/data/shapes/characters/banker.cs");
exec("~/data/shapes/characters/hunter.cs");
exec("~/data/shapes/characters/toughsheriff.cs");
exec("~/data/shapes/characters/nicesheriff.cs");
exec("~/data/shapes/characters/gunslingerfemale.cs");
exec("~/data/shapes/characters/gunslingermale.cs");
exec("~/data/shapes/characters/banditfemale.cs");
exec("~/data/shapes/characters/banditmale.cs");
exec("~/data/shapes/characters/deputy.cs");
exec("~/data/shapes/characters/deer.cs");
exec("~/data/shapes/characters/rabbit.cs");
exec("~/data/shapes/characters/bear.cs");
exec("~/data/shapes/characters/sasquatch.cs");
exec("~/data/shapes/characters/horse.cs");
exec("~/data/shapes/characters/toughgunslinger.cs");
exec("~/data/shapes/characters/nicegunslinger.cs");
exec("~/data/shapes/characters/mrwhite.cs");
exec("~/data/shapes/characters/mrwong.cs");
exec("~/data/shapes/characters/madrussian.cs");
exec("~/data/shapes/characters/engine.cs");
exec("~/data/shapes/characters/coalcar.cs");
exec("~/data/shapes/characters/carone.cs");
exec("~/data/shapes/characters/cartwo.cs");
exec("~/data/shapes/characters/logcar.cs");
exec("~/data/shapes/characters/wagon.cs");
exec("~/data/shapes/characters/horses.cs");
exec("~/data/shapes/characters/horse.cs");

datablock SLGameObjData(BasePortraitData)
{
   portraitOffset = "0 0 7.6";
   portraitRotation = "5";
   portraitHeight = "10";
   portraitZoom = "16";
   portraitAngle = "3";
   portraitFOV = "7.5";
   
   // idle animations
	portraitTimeLow = 5;
	portraitTimeHigh = 15;
	portraitAnimations = "portraitlook tiphat";
};

// ------------- TOWN UNITS ---------------

datablock SLGameObjData(MaleCiv)
{
   // SLGameObjData
   snapGrid = $SnapGrid::Detail;

   addCmpData = MaleCharacterData;
   addCmpData = BaseAIData;
   addCmpData = CivilianCmdData;

   shapeFile = "~/data/shapes/characters/maleciv.dts";
   addMount = "Phonyhat 0";

   // Happiness
   happyCount = 20;
   happyTime  = 5.0;
   happyInc   = 20;

   goldCost = 0;
   
   // health
   healthMax = 25;

	//Footprint
	footprintGrid = $SnapGrid::Detail;
	footprintSize = "0 0";

	// shadow for the object
	shadowDecal = DropShadowDecal;
	shadowScale = 1;
	shadowOffsetStatic = "0 0";
	shadowOffsetDynamic = "0 0.2";
	shadowAngleStatic = 0;
	shadowAngleDynamic = true;
	
	//Naming
	nameKey = "citizen_male_name";
	
	//audio
    audioList = "ACC : m_civilian_ACC01 m_civilian_ACC02 m_civilian_ACC03 m_civilian_ACC04";
    audioList = "BMT : m_civilian_BMT01 m_civilian_BMT02 m_civilian_BMT03 m_civilian_BMT04";
    audioList = "BNK : m_civilian_BNK01 m_civilian_BNK02 m_civilian_BNK03";
    audioList = "BRI : m_civilian_BRI01 m_civilian_BRI02";
    audioList = "BSO : m_civilian_BSO01 m_civilian_BSO02 m_civilian_BSO03";
    audioList = "CHU : m_civilian_CHU01 m_civilian_CHU02 m_civilian_CHU03";
    audioList = "CMT : m_civilian_CMT01 m_civilian_CMT02";
    audioList = "DNY : m_civilian_DNY01 m_civilian_DNY02 m_civilian_DNY03 m_civilian_DNY04";
    audioList = "FAR : m_civilian_FAR01 m_civilian_FAR03";
    audioList = "FPT : m_civilian_FPT01 m_civilian_FPT02 m_civilian_FPT03";
    audioList = "FTN : m_civilian_FTN01 m_civilian_FTN02 m_civilian_FTN03";
    audioList = "GMI : m_civilian_GMI01 m_civilian_GMI02 m_civilian_GMI03";
    audioList = "GRA : m_civilian_GRA01 m_civilian_GRA02 m_civilian_GRA03";
    audioList = "GST : m_civilian_GST01 m_civilian_GST02 m_civilian_GST03 m_civilian_GST04";
    audioList = "GZB : m_civilian_GZB01 m_civilian_GZB02 m_civilian_GZB03";
    audioList = "HOT : m_civilian_HOT01 m_civilian_HOT02 m_civilian_HOT03";
    audioList = "IHA : m_civilian_IHA01 m_civilian_IHA02 m_civilian_IHA03 m_civilian_IHA04 m_civilian_IHA05 m_civilian_IHA06 m_civilian_IHA07 m_civilian_IHA08 m_civilian_IHA09 m_civilian_IHA10";
    audioList = "IHO : m_civilian_IHO01 m_civilian_IHO02 m_civilian_IHO03";
    audioList = "IJO : m_civilian_IJO01 m_civilian_IJO02 m_civilian_IJO03";
    audioList = "ISA : m_civilian_ISA01 m_civilian_ISA02 m_civilian_ISA03";
    audioList = "LCA : m_civilian_LCA01 m_civilian_LCA02 m_civilian_LCA03";
    audioList = "LEV : m_civilian_LEV01 m_civilian_LEV02 m_civilian_LEV03";
    audioList = "LML : m_civilian_LML01 m_civilian_LML02 m_civilian_LML03";
    audioList = "NFO : m_civilian_NFO01 m_civilian_NFO02 m_civilian_NFO03";
    audioList = "NWA : m_civilian_NWA01 m_civilian_NWA02 m_civilian_NWA03";
    audioList = "OUT : m_civilian_OUT01";
    audioList = "PLT : m_civilian_PLT01 m_civilian_PLT02";
    audioList = "RAN : m_civilian_RAN01 m_civilian_RAN02 m_civilian_RAN03 m_civilian_RAN04 m_civilian_RAN05 m_civilian_RAN06";
    audioList = "SBA : m_civilian_SBA01 m_civilian_SBA02 m_civilian_SBA03";
    audioList = "SDR : m_civilian_SDR01 m_civilian_SDR02 m_civilian_SDR03";
    audioList = "SEL : m_civilian_SEL01 m_civilian_SEL02 m_civilian_SEL03 m_civilian_SEL04";
    audioList = "SFA : m_civilian_SFA01 m_civilian_SFA02 m_civilian_SFA03";
    audioList = "SFI : m_civilian_SFI01 m_civilian_SFI02 m_civilian_SFI03";
    audioList = "SHA : m_civilian_SHA01 m_civilian_SHA02 m_civilian_SHA03 m_civilian_SHA04";
    audioList = "SMO : m_civilian_SMO01 m_civilian_SMO02 m_civilian_SMO03 m_civilian_SMO04 m_civilian_SMO05";
    audioList = "SOO : m_civilian_SOO01 m_civilian_SOO02 m_civilian_SOO03 m_civilian_SOO04";
    audioList = "SPL : m_civilian_SPL01 m_civilian_SPL02 m_civilian_SPL03";
    audioList = "SSO : m_civilian_SSO01 m_civilian_SSO02 m_civilian_SSO03 m_civilian_SSO04 m_civilian_SSO05";
    audioList = "STO : m_civilian_STO01 m_civilian_STO02 m_civilian_STO03";
    audioList = "STT : m_civilian_STT01 m_civilian_STT02 m_civilian_STT03";
    audioList = "THO : m_civilian_THO01 m_civilian_THO02 m_civilian_THO03 m_civilian_THO04";
    audioList = "TPO : m_civilian_TPO01 m_civilian_TPO02 m_civilian_TPO03 m_civilian_TPO04";
    audioList = "TWB : m_civilian_TWB01 m_civilian_TWB02 m_civilian_TWB03";
    audioList = "WCM : m_civilian_WCM01 m_civilian_WCM02 m_civilian_WCM03";
    audioList = "WEL : m_civilian_WEL01 m_civilian_WEL02 m_civilian_WEL03";
    audioList = "WML : m_civilian_WML01 m_civilian_WML02 m_civilian_WML03";
    audioList = "WOO : m_civilian_WOO01 m_civilian_WOO02";
    audioList = "WTO : m_civilian_WTO01 m_civilian_WTO02";
    audioList = "WTW : m_civilian_WTW01 m_civilian_WTW02";
    audioList = "DSEL : m_drunk_SEL01 m_drunk_SEL02 m_drunk_SEL03";
    audioList = "DIHA : m_drunk_IHA01 m_drunk_IHA02 m_drunk_IHA03";
    audioList = "DISA : m_drunk_ISA01 m_drunk_ISA02 m_drunk_ISA03";
    audioList = "DDNY : m_drunk_DNY01 m_drunk_DNY02 m_drunk_DNY03";
	
	//Animations
	addIdle = "idle00 5";
	addIdle = "idle01 5";
	addIdle = "idle02 5";
	addIdle = "idle03 5";
	
	//portraitAnimations = "portraitlook tiphat";
	portraitImage = "assets/client/ui/hud/malecivnormal_portrait";
	portraitImageNeutral = "assets/client/ui/hud/malecivnormaldefault_portrait";

	// protest information
   homeProtestMount = "Protestsignhome 2";
   workProtestMount = "Protestsignjob 2";
   homeProtestAnim  = "protest";
   workProtestAnim  = "protest";
   //effects
   addGameEffect = "douse douseEffectronData .5 .5 2 " @ $Detail::High;

	sightRange = 20;
};

datablock SLGameObjData(FemaleCiv)
{
   // SLGameObjData
   snapGrid = $SnapGrid::Detail;
   objTileOffset = "0 0";
   
   addCmpData = FemaleCharacterData;
   addCmpData = BaseAIData;
   addCmpData = CivilianCmdData;

  	shapeFile = "~/data/shapes/characters/femaleciv.dts";
  	addMount = "Phonyhat 0";
  	
  	// health
   healthMax = 25;

	//Footprint
	footprintGrid = $SnapGrid::Detail;
	footprintSize = "0 0";

	// shadow for the object
	shadowDecal = DropShadowDecal;
	shadowScale = 1;
	shadowOffsetStatic = "0 0";
	shadowOffsetDynamic = "0 0.2";
	shadowAngleStatic = 0;
	shadowAngleDynamic = true;
	
	//Naming
	nameKey = "citizen_female_name";
	
	//audio
    audioList = "ACC : f_civilian_ACC01 f_civilian_ACC02 f_civilian_ACC03 f_civilian_ACC04";
    audioList = "BMT : f_civilian_BMT01 f_civilian_BMT02 f_civilian_BMT03 f_civilian_BMT04";
    audioList = "BNK : f_civilian_BNK01 f_civilian_BNK02 f_civilian_BNK03";
    audioList = "BRI : f_civilian_BRI01 f_civilian_BRI02 f_civilian_BRI03";
    audioList = "BSO : f_civilian_BSO01 f_civilian_BSO02 f_civilian_BSO03 f_civilian_BSO04 f_civilian_BSO05";
    audioList = "CHU : f_civilian_CHU01";
    audioList = "CMT : f_civilian_CMT01 f_civilian_CMT03 f_civilian_CMT04";
    audioList = "DNY : f_civilian_DNY01 f_civilian_DNY02 f_civilian_DNY03 f_civilian_DNY04";
    audioList = "FAR : f_civilian_FAR01 f_civilian_FAR02 f_civilian_FAR03 f_civilian_FAR04";
    audioList = "FPT : f_civilian_FPT01 f_civilian_FPT02 f_civilian_FPT03";
    audioList = "FTN : f_civilian_FTN01 f_civilian_FTN02 f_civilian_FTN03";
    audioList = "GMI : f_civilian_GMI01 f_civilian_GMI02 f_civilian_GMI03";
    audioList = "GRA : f_civilian_GRA01 f_civilian_GRA02";
    audioList = "GST : f_civilian_GST01 f_civilian_GST02 f_civilian_GST03 f_civilian_GST04 f_civilian_GST05";
    audioList = "GZB : f_civilian_GZB01 f_civilian_GZB02 f_civilian_GZB03 f_civilian_GZB05";
    audioList = "HOT : f_civilian_HOT02 f_civilian_HOT03 f_civilian_HOT05 f_civilian_HOT06";
    audioList = "IHA : f_civilian_IHA01 f_civilian_IHA02 f_civilian_IHA03 f_civilian_IHA04 f_civilian_IHA05 f_civilian_IHA06 f_civilian_IHA07 f_civilian_IHA08 f_civilian_IHA09 f_civilian_IHA10 f_civilian_IHA11 f_civilian_IHA12";
    audioList = "IHO : f_civilian_IHO01 f_civilian_IHO02 f_civilian_IHO03";
    audioList = "IJO : f_civilian_IJO01 f_civilian_IJO02 f_civilian_IJO03";
    audioList = "ISA : f_civilian_ISA01 f_civilian_ISA02 f_civilian_ISA03 f_civilian_ISA04";
    audioList = "LCA : f_civilian_LCA01 f_civilian_LCA02";
    audioList = "LEV : f_civilian_LEV01 f_civilian_LEV02 f_civilian_LEV03";
    audioList = "LML : f_civilian_LML01 f_civilian_LML02";
    audioList = "NFO : f_civilian_NFO01 f_civilian_NFO02 f_civilian_NFO03";
    audioList = "NWA : f_civilian_NWA01 f_civilian_NWA02 f_civilian_NWA03";
    audioList = "OUT : f_civilian_OUT01 f_civilian_OUT02 f_civilian_OUT03";
    audioList = "PLT : f_civilian_PLT01 f_civilian_PLT02";
    audioList = "RAN : f_civilian_RAN01 f_civilian_RAN02 f_civilian_RAN03 f_civilian_RAN04 f_civilian_RAN05";
    audioList = "SBA : f_civilian_SBA01 f_civilian_SBA02 f_civilian_SBA03";
    audioList = "SDR : f_civilian_SDR01 f_civilian_SDR02 f_civilian_SDR03";
    audioList = "SEL : f_civilian_SEL01 f_civilian_SEL02 f_civilian_SEL03 f_civilian_SEL04";
    audioList = "SFA : f_civilian_SFA01 f_civilian_SFA02 f_civilian_SFA03";
    audioList = "SFI : f_civilian_SFI01 f_civilian_SFI02 f_civilian_SFI03";
    audioList = "SHA : f_civilian_SHA01 f_civilian_SHA02";
    audioList = "SMO : f_civilian_SMO01 f_civilian_SMO02 f_civilian_SMO03 f_civilian_SMO04";
    audioList = "SOO : f_civilian_SOO01 f_civilian_SOO02 f_civilian_SOO03 f_civilian_SOO04";
    audioList = "SPL : f_civilian_SPL01 f_civilian_SPL02 f_civilian_SPL03";
    audioList = "SSO : f_civilian_SSO01 f_civilian_SSO02 f_civilian_SSO03 f_civilian_SSO04";
    audioList = "STO : f_civilian_STO01 f_civilian_STO02 f_civilian_STO03";
    audioList = "STT : f_civilian_STT01 f_civilian_STT02 f_civilian_STT03";
    audioList = "THO : f_civilian_THO01 f_civilian_THO02 f_civilian_THO03 f_civilian_THO04 f_civilian_THO05";
    audioList = "TPO : f_civilian_TPO01 f_civilian_TPO03 f_civilian_TPO04";
    audioList = "TWB : f_civilian_TWB01 f_civilian_TWB02";
    audioList = "WCM : f_civilian_WCM01 f_civilian_WCM02 f_civilian_WCM03";
    audioList = "WEL : f_civilian_WEL01 f_civilian_WEL02 f_civilian_WEL03";
    audioList = "WML : f_civilian_WML01 f_civilian_WML02 f_civilian_WML03";
    audioList = "WOO : f_civilian_WOO01 f_civilian_WOO02";
    audioList = "WTO : f_civilian_WTO01 f_civilian_WTO03";
    audioList = "WTW : f_civilian_WTW01 f_civilian_WTW02";
    audioList = "DSEL : f_drunk_SEL01 f_drunk_SEL02 f_drunk_SEL03";
    audioList = "DIHA : f_drunk_IHA01 f_drunk_IHA02 f_drunk_IHA03";
    audioList = "DISA : f_drunk_ISA01 f_drunk_ISA02 f_drunk_ISA03";
    audioList = "DDNY : f_drunk_DNY01 f_drunk_DNY02 f_drunk_DNY03";

   addIdle = "idle00 5";
   addIdle = "idle01 5";

	portraitAnimations = "portraitlook tiphat";
	portraitImage = "assets/client/ui/hud/femalecivnormal_portrait";
	portraitImageNeutral = "assets/client/ui/hud/femalecivnormaldefault_portrait";

	// protest information
   homeProtestMount = "Protestsignhome 2";
   workProtestMount = "Protestsignjob 2";
   homeProtestAnim  = "protest";
   workProtestAnim  = "protest";
   
   //effects
   addGameEffect = "douse douseEffectronData .5 .5 2 " @ $Detail::High;
   
	sightRange = 20;
};
// ------------ HEROES ---------------

// HUNTER
datablock SLGameObjData(Hunter : BasePortraitData)
{
   // SLGameObjData
   snapGrid = $SnapGrid::Detail;
   objTileOffset = "0 0";
   
   addCmpData = HeroMaleCharacterData;
   addCmpData = HeroAIData;
   addCmpData = HeroCmdData;
   addCmpData = CombatData_Hunter;

  	shapeFile = "~/data/shapes/characters/hunter.dts";
  	addMount = "Hunterherohat 0";

  	// health
   healthMax = 175;
   healthExtent = "49 12";
   healthScreenOffset = "0 0";
   healthWorldOffset = "0 0 4";
   healthImage = "~/client/ui/healthBar";
   healthBBoxHeight = false;
   healingRate = 12.0;
   
   // shadow for the object
	shadowDecal = DropShadowDecal;
	shadowScale = 1;
	shadowOffsetStatic = "0 0";
	shadowOffsetDynamic = "0 0.2";
	shadowAngleStatic = 0;
	shadowAngleDynamic = true;

	//Naming
	nameKey = "hero_hunter_name";
	
	heroPortraitOffset = "0 0 0";
   heroPortraitRotation = "-20";
   heroPortraitHeight = "1.6";
   heroPortraitZoom = "27.5";
   heroPortraitAngle = "3";
   heroPortraitFOV = "7.5";
   
   addIdle = "idle01 3.4";   
   addIdle = "idle00 3.8";  
   addIdle = "idle02 3.8";  
   addIdle = "tiphat 2.3"; 
   addIdle = "portraitlook 2.3";
   addIdle = "happy 2.3";
   addIdle = "rejoice 2.3";

	portraitAnimations = "root portraitlook";
	portraitFocus = "idle02";
	portraitHappy = "happy";
	portraitSad = "portrait02";
	portraitImage = "assets/client/ui/hud/hunter_portrait";
	
	//audio
	audioList = "SEL : hunter_SEL01 hunter_SEL02 hunter_SEL03 hunter_SEL04";
	audioList = "ACC : hunter_ACC01 hunter_ACC02 hunter_ACC03 hunter_ACC04";
	audioList = "DNY : hunter_DNY01 hunter_DNY02 hunter_DNY03";
	audioList = "ATT : hunter_ATT01 hunter_ATT02 hunter_ATT03";
	audioList = "COM : hunter_COM01 hunter_COM02 hunter_COM03";
	audioList = "DIE : hunter_DIE01 hunter_DIE02 hunter_DIE03";
	
	//Effects
	addGameEffect = "combat sheriffshootEffectronData 0.8 2.3 2.7 " @ $Detail::Medium;
	addGameEffect = "douse douseEffectronData .5 .5 2 " @ $Detail::High;
	addGameEffect = "heal healingEffectronData 0 0 2 " @ $Detail::Medium;

	sightRange = 20;
	
	// hero will always have his hat
	removeHat = false;
};

// FARMER
datablock SLGameObjData(Farmer : BasePortraitData)
{
   // SLGameObjData
   snapGrid = $SnapGrid::Detail;
   objTileOffset = "0 0";
   
   addCmpData = HeroMaleCharacterData;
   addCmpData = HeroAIData;
   addCmpData = HeroCmdData;
   addCmpData = CombatData_MrWhite;

  	shapeFile = "~/data/shapes/characters/farmer.dts";
	addMount = "Farmerherohat 0";

  	// health
   healthMax = 175;
   healthExtent = "49 12";
   healthScreenOffset = "0 0";
   healthWorldOffset = "0 0 4";
   healthImage = "~/client/ui/healthBar";
   healthBBoxHeight = false;
   healingRate = 12.0;
   
   // shadow for the object
	shadowDecal = DropShadowDecal;
	shadowScale = 1;
	shadowOffsetStatic = "0 0";
	shadowOffsetDynamic = "0 0.2";
	shadowAngleStatic = 0;
	shadowAngleDynamic = true;

	//Naming
	nameKey = "hero_farmer_name";
	
	heroPortraitOffset = "0 0 0";
   heroPortraitRotation = "20";
   heroPortraitHeight = "1.6";
   heroPortraitZoom = "27.5";
   heroPortraitAngle = "3";
   heroPortraitFOV = "7.5";
    
   addIdle = "idle01 3.4";   
   addIdle = "idle00 3.8";  
   addIdle = "tiphat 2.3"; 
   addIdle = "portraitlook 2.3";
   addIdle = "portrait03 2.3";

	portraitAnimations = "portraitlook tiphat";
	portraitFocus = "portrait02";
	portraitHappy = "portrait03";
	portraitSad = "portrait01";
	portraitImage = "assets/client/ui/hud/farmer_portrait";
	
	//audio
	audioList = "SEL : farmer_SEL01 farmer_SEL02 farmer_SEL03 farmer_SEL04";
	audioList = "ACC : farmer_ACC01 farmer_ACC02 farmer_ACC03 farmer_ACC04";
	audioList = "DNY : farmer_DNY01 farmer_DNY02 farmer_DNY03";
	audioList = "ATT : farmer_ATT01 farmer_ATT02 farmer_ATT03";
	audioList = "COM : farmer_COM01 farmer_COM02 farmer_COM03 farmer_COM04";
	audioList = "DIE : farmer_DIE01 farmer_DIE02 farmer_DIE03";
	
	//Effects
	addGameEffect = "combat sheriffshootEffectronData 0.8 3.6 2.7 " @ $Detail::High;
	addGameEffect = "douse douseEffectronData .5 .5 2 " @ $Detail::Medium;
	addGameEffect = "heal healingEffectronData 0 0 2 " @ $Detail::Medium;
	
	sightRange = 20;
	
	// hero will always have his hat
	removeHat = false;
};

// BANKER
datablock SLGameObjData(Banker : BasePortraitData)
{
   // SLGameObjData
   snapGrid = $SnapGrid::Detail;
   objTileOffset = "0 0";
   
   addCmpData = HeroFemaleCharacterData;
   addCmpData = HeroAIData;
   addCmpData = HeroCmdData;
   addCmpData = CombatData_Banker;

  	shapeFile = "~/data/shapes/characters/banker.dts";
  	addMount = "banditfemalehat 0";

  	// health
   healthMax = 170;
   healthExtent = "49 12";
   healthScreenOffset = "0 0";
   healthWorldOffset = "0 0 4";
   healthImage = "~/client/ui/healthBar.jpg";
   healthBBoxHeight = false;
   healingRate = 12.0;

   // shadow for the object
	shadowDecal = DropShadowDecal;
	shadowScale = 1;
	shadowOffsetStatic = "0 0";
	shadowOffsetDynamic = "0 0.2";
	shadowAngleStatic = 0;
	shadowAngleDynamic = true;
	
	//Naming
	nameKey = "hero_banker_name";
	
	heroPortraitOffset = "0 0 0";
   heroPortraitRotation = "0";
   heroPortraitHeight = "1.6";
   heroPortraitZoom = "27.5";
   heroPortraitAngle = "3";
   heroPortraitFOV = "7.5";

   addIdle = "portraitlook 5";
   addIdle = "idle02 5";
   addIdle = "portrait00 5";
   addIdle = "portrait03 5";

	portraitAnimations = "portrait00 portraitlook";
	portraitFocus = "portrait03";
	portraitHappy = "portrait01";
	portraitSad = "portrait02";
	portraitImage = "assets/client/ui/hud/banker_portrait";
	
	//audio
	audioList = "SEL : banker_SEL01 banker_SEL02 banker_SEL03 banker_SEL04";
	audioList = "ACC : banker_ACC01 banker_ACC02 banker_ACC03 banker_ACC04";
	audioList = "DNY : banker_DNY01 banker_DNY02 banker_DNY03";
	audioList = "ATT : banker_ATT01 banker_ATT02 banker_ATT03";
	audioList = "COM : banker_COM01 banker_COM02 banker_COM03";
	audioList = "DIE : banker_DIE01 banker_DIE02 banker_DIE03";
	
	//Effects
	addGameEffect = "combat bankerEffectronData 0.2 2.4 2.7 " @ $Detail::High;
	addGameEffect = "douse douseEffectronData .5 .5 2 " @ $Detail::Medium;
	addGameEffect = "heal healingEffectronData 0 0 2 " @ $Detail::Medium;
	
	sightRange = 20;
	
	// hero will always have his hat
	removeHat = false;
};

// ------------- PLAYER COMBAT UNITS --------------
// Tough Sheriff
datablock SLGameObjData(Toughsheriff)
{
   // SLGameObjData
   snapGrid = $SnapGrid::Detail;
   objTileOffset = "0 0";
   
   addCmpData = ToughLawmanData;
   addCmpData = CombatAIData;
   addCmpData = CombatData_SheriffTough;
   addCmpData = CombatCmdData;

  	shapeFile = "~/data/shapes/characters/sheriff.dts";
  	
  	// health
   healthMax = 200;
   healthExtent = "49 12";
   healthScreenOffset = "0 0";
   healthWorldOffset = "0 0 4";
   healthImage = "~/client/ui/healthBar.jpg";
   healthBBoxHeight = false;

   // shadow for the object
	shadowDecal = DropShadowDecal;
	shadowScale = 1;
	shadowOffsetStatic = "0 0";
	shadowOffsetDynamic = "0 0.2";
	shadowAngleStatic = 0;
	shadowAngleDynamic = true;
	
	//Naming
	nameKey = "citizen_male_name";
	
	addIdle = "rocking 3.8";		
	addIdle = "portraitlook 3.8";
	addIdle = "spit 1.8";
	
	//Effects
	addGameEffect = "combat sheriffshootEffectronData 0.7 3.4 2.7 " @ $Detail::Medium;
	addGameEffect = "heal healingEffectronData 0 0 2 " @ $Detail::Medium;
	
	sightRange = 20;
	
	portraitImage = "assets/client/ui/hud/toughsheriff_portrait";
	
	//audio
    audioList = "ACC : bh_sheriff_ACC01 bh_sheriff_ACC02 bh_sheriff_ACC03";
    audioList = "ATT : bh_sheriff_ATT01 bh_sheriff_ATT02 bh_sheriff_ATT03";
    audioList = "COM : bh_sheriff_COM01 bh_sheriff_COM02 bh_sheriff_COM03 bh_sheriff_COM04";
    audioList = "DIE : bh_sheriff_DIE01 bh_sheriff_DIE02 bh_sheriff_DIE03";
    audioList = "DNY : bh_sheriff_DNY01 bh_sheriff_DNY02 bh_sheriff_DNY03";
    audioList = "SBA : bh_sheriff_SBA01 bh_sheriff_SBA02 bh_sheriff_SBA03";
    audioList = "SEL : bh_sheriff_SEL01 bh_sheriff_SEL02 bh_sheriff_SEL03";
    
};

// Nice Sheriff
datablock SLGameObjData(Nicesheriff)
{
   // SLGameObjData
   snapGrid = $SnapGrid::Detail;
      
   addCmpData = NiceLawmanData;
   addCmpData = CombatAIData;
   addCmpData = CombatData_GunslingerNice;
   addCmpData = CombatCmdData;

  	shapeFile = "~/data/shapes/characters/sheriff.dts";
  	skin = "good";

  	// health
   healthMax = 155;
   healthExtent = "49 12";
   healthScreenOffset = "0 0";
   healthWorldOffset = "0 0 4";
   healthImage = "~/client/ui/healthBar.jpg";
   healthBBoxHeight = false;

   // shadow for the object
	shadowDecal = DropShadowDecal;
	shadowScale = 1;
	shadowOffsetStatic = "0 0";
	shadowOffsetDynamic = "0 0.2";
	shadowAngleStatic = 0;
	shadowAngleDynamic = true;
	
	//Naming
	nameKey = "citizen_male_name";
	
	addIdle = "rocking 3.8";
	addIdle = "idle_look 3.8";	
	addIdle = "portraitlook 3.8";
	
	//Effects
	addGameEffect = "combat sheriffscaredEffectronData 0 1 3.2 " @ $Detail::Medium;
	addGameEffect = "heal healingEffectronData 0 0 2 " @ $Detail::Medium;
	
	sightRange = 20;
	
	portraitImage = "assets/client/ui/hud/goodsheriff_portrait";
	
	//audio
    audioList = "ACC : wh_sheriff_ACC01 wh_sheriff_ACC02 wh_sheriff_ACC03";
    audioList = "ATT : wh_sheriff_ATT01 wh_sheriff_ATT02 wh_sheriff_ATT03";
    audioList = "COM : wh_sheriff_COM01 wh_sheriff_COM02 wh_sheriff_COM03";
    audioList = "DIE : wh_sheriff_DIE01 wh_sheriff_DIE02 wh_sheriff_DIE03 wh_sheriff_DIE04";
    audioList = "DNY : wh_sheriff_DNY01 wh_sheriff_DNY02 wh_sheriff_DNY03";
    audioList = "SBA : wh_sheriff_SBA01 wh_sheriff_SBA02 wh_sheriff_SBA03";
    audioList = "SEL : wh_sheriff_SEL01 wh_sheriff_SEL02 wh_sheriff_SEL03";

};

// Deputy
datablock SLGameObjData(Deputy)
{
   // SLGameObjData
   snapGrid = $SnapGrid::Detail;
   objTileOffset = "0 0";
   
   addCmpData = LawmanData;
   addCmpData = CombatAIData;
   addCmpData = CombatData;
   addCmpData = CombatCmdData;

  	shapeFile = "~/data/shapes/characters/deputy.dts";
  	addMount = "deputyhat 0";
  	
  	// health
   healthMax = 145;
   healthExtent = "49 12";
   healthScreenOffset = "0 0";
   healthWorldOffset = "0 0 4";
   healthImage = "~/client/ui/healthBar";
   healthBBoxHeight = false;

   // shadow for the object
	shadowDecal = DropShadowDecal;
	shadowScale = 1;
	shadowOffsetStatic = "0 0";
	shadowOffsetDynamic = "0 0.2";
	shadowAngleStatic = 0;
	shadowAngleDynamic = true;
	
	//Naming
	nameKey = "citizen_male_name";
	
	addIdle = "rocking 3.8";
	addIdle = "idle_look 3.8";
	addIdle = "spit 1.5";
	addIdle = "portraitlook 3.8";
	addIdle = "portrait03 3.8";
	addIdle = "tiphat 1.6";
	
	//Effects
	addGameEffect = "combat deputyEffectronData 0 2.9 2.5 " @ $Detail::Medium;
	addGameEffect = "heal healingEffectronData 0 0 2 " @ $Detail::Medium;
	
	
	sightRange = 20;
	
	portraitImage = "assets/client/ui/hud/deputy_portrait";
	
	//audio
    audioList = "ACC : deputy_ACC01 deputy_ACC02 deputy_ACC03";
    audioList = "ATT : deputy_ATT01 deputy_ATT02 deputy_ATT03";
    audioList = "COM : deputy_COM01 deputy_COM02 deputy_COM03";
    audioList = "DIE : deputy_DIE01 deputy_DIE02 deputy_DIE03";
    audioList = "DNY : deputy_DNY01 deputy_DNY02 deputy_DNY03";
    audioList = "SBA : deputy_SBA01 deputy_SBA02 deputy_SBA03";
    audioList = "SEL : deputy_SEL01 deputy_SEL02 deputy_SEL03";

};

// Male Gunslinger
datablock SLGameObjData(Malegunslinger)
{
   // SLGameObjData
   snapGrid = $SnapGrid::Detail;
   objTileOffset = "0 0";

   addCmpData = MaleNotTownsfolkData;
   addCmpData = CombatAIData;
   addCmpData = CombatData_GunslingerMale;
   addCmpData = CombatCmdData;

  	shapeFile = "~/data/shapes/characters/banditmale.dts";
  	skin = "gunslingermale";
  	addMount = "bandithat 0";
  	
  	// health
   healthMax = 135;
   healthExtent = "49 12";
   healthScreenOffset = "0 0";
   healthWorldOffset = "0 0 4";
   healthImage = "~/client/ui/healthBar";
   healthBBoxHeight = false;

   // shadow for the object
	shadowDecal = DropShadowDecal;
	shadowScale = 1;
	shadowOffsetStatic = "0 0";
	shadowOffsetDynamic = "0 0.2";
	shadowAngleStatic = 0;
	shadowAngleDynamic = true;
	
	//Naming
	nameKey = "citizen_male_name";
	
   addIdle = "spintrick 3.8 revolver 2"; 
   addIdle = "portraitlook 3.5"; 
   addIdle = "rocking 3.8";  
   addIdle = "tiphat 2.3"; 
   addIdle = "spit 1.5";
   
   portraitImage = "assets/client/ui/hud/gunslingermale_portrait";
	
	//audio
    audioList = "ACC : male_n_gunslinger_ACC01 male_n_gunslinger_ACC02 male_n_gunslinger_ACC03 male_n_gunslinger_ACC04";
    audioList = "ATT : male_n_gunslinger_ATT01 male_n_gunslinger_ATT02 male_n_gunslinger_ATT03 male_n_gunslinger_ATT04";
    audioList = "COM : male_n_gunslinger_COM01 male_n_gunslinger_COM02 male_n_gunslinger_COM03 male_n_gunslinger_COM04";
    audioList = "DIE : male_n_gunslinger_DIE01 male_n_gunslinger_DIE02 male_n_gunslinger_DIE03 male_n_gunslinger_DIE04";
    audioList = "DNY : male_n_gunslinger_DNY01 male_n_gunslinger_DNY02 male_n_gunslinger_DNY03 male_n_gunslinger_DNY04";
    audioList = "SEL : male_n_gunslinger_SEL01 male_n_gunslinger_SEL02 male_n_gunslinger_SEL03 male_n_gunslinger_SEL04";
	
	//Effects
	addGameEffect = "combat dualgun1EffectronData 0.6 2.5 2.6 " @ $Detail::Medium;
	addGameEffect = "combat dualgun2EffectronData -0.6 2 2.4 " @ $Detail::Medium;
	addGameEffect = "heal healingEffectronData 0 0 2 " @ $Detail::Medium;
	
	sightRange = 20;
};

// Female Gunslinger
datablock SLGameObjData(Femalegunslinger)
{
   // SLGameObjData
   snapGrid = $SnapGrid::Detail;
   objTileOffset = "0 0";
   
   addCmpData = FemaleNotTownsfolkData;
   addCmpData = CombatAIData;
   addCmpData = CombatData_GunslingerFemale;
   addCmpData = CombatCmdData;

  	shapeFile = "~/data/shapes/characters/banditfemale.dts";
  	skin = "gunslingerfemale";
  	addMount = "banditfemalehat 0";
  	
  	// health
   healthMax = 135;
   healthExtent = "49 12";
   healthScreenOffset = "0 0";
   healthWorldOffset = "0 0 4";
   healthImage = "~/client/ui/healthBar";
   healthBBoxHeight = false;

   // shadow for the object
	shadowDecal = DropShadowDecal;
	shadowScale = 1;
	shadowOffsetStatic = "0 0";
	shadowOffsetDynamic = "0 0.2";
	shadowAngleStatic = 0;
	shadowAngleDynamic = true;
	
	//Naming
	nameKey = "citizen_female_name";
	
	addIdle = "hipshake 2.3";
	addIdle = "portraitlook 3.8";
	
	portraitImage = "assets/client/ui/hud/gunslingerfemale_portrait";
	
	//audio
    audioList = "ACC : female_gunslinger_ACC01 female_gunslinger_ACC02 female_gunslinger_ACC03 female_gunslinger_ACC04";
    audioList = "ATT : female_gunslinger_ATT01 female_gunslinger_ATT02 female_gunslinger_ATT03 female_gunslinger_ATT04";
    audioList = "COM : female_gunslinger_COM01 female_gunslinger_COM02 female_gunslinger_COM03 female_gunslinger_COM04";
    audioList = "DIE : female_gunslinger_DIE01 female_gunslinger_DIE02 female_gunslinger_DIE03";
    audioList = "DNY : female_gunslinger_DNY01 female_gunslinger_DNY02 female_gunslinger_DNY03";
    audioList = "SEL : female_gunslinger_SEL01 female_gunslinger_SEL02 female_gunslinger_SEL03 female_gunslinger_SEL04";
	
	//Effects
	addGameEffect = "combat sheriffshootEffectronData 0.7 3 2.7 " @ $Detail::Medium;
	addGameEffect = "heal healingEffectronData 0 0 2 " @ $Detail::Medium;
	
	sightRange = 20;
};

// Nice Gunslinger
datablock SLGameObjData(Nicegunslinger)
{
   // SLGameObjData
   snapGrid = $SnapGrid::Detail;
   objTileOffset = "0 0";
   
   addCmpData = NiceMaleCharacterData;
   addCmpData = CombatAIData;
   addCmpData = CombatData_GunslingerNice;
   addCmpData = CombatCmdData;

  	shapeFile = "~/data/shapes/characters/nicegunslinger.dts";
  	addMount = "goodhat 0";

  	// health
   healthMax = 135;
   healthExtent = "49 12";
   healthScreenOffset = "0 0";
   healthWorldOffset = "0 0 4";
   healthImage = "~/client/ui/healthBar";
   healthBBoxHeight = false;

   // shadow for the object
	shadowDecal = DropShadowDecal;
	shadowScale = 1;
	shadowOffsetStatic = "0 0";
	shadowOffsetDynamic = "0 0.2";
	shadowAngleStatic = 0;
	shadowAngleDynamic = true;
	
	//Naming
	nameKey = "citizen_male_name";
	
   addIdle = "spintrick 3.8 revolver 2"; 
   addIdle = "idle_look 3.4";   
   addIdle = "rocking 3.8";  
   addIdle = "tiphat 2.3"; 
   addIdle = "idle00 1.5";
   addIdle = "portraitlook 3.5";
   
   portraitImage = "assets/client/ui/hud/goodgunslinger_portrait";

	//audio
    audioList = "ACC : male_wh_gunslinger_ACC01 male_wh_gunslinger_ACC02 male_wh_gunslinger_ACC03 male_wh_gunslinger_ACC04";
    audioList = "ATT : male_wh_gunslinger_ATT01 male_wh_gunslinger_ATT02 male_wh_gunslinger_ATT03 male_wh_gunslinger_ATT04";
    audioList = "COM : male_wh_gunslinger_COM01 male_wh_gunslinger_COM02 male_wh_gunslinger_COM03 male_wh_gunslinger_COM04";
    audioList = "DIE : male_wh_gunslinger_DIE01 male_wh_gunslinger_DIE02 male_wh_gunslinger_DIE03 male_wh_gunslinger_DIE04";
    audioList = "DNY : male_wh_gunslinger_DNY01 male_wh_gunslinger_DNY02 male_wh_gunslinger_DNY03 male_wh_gunslinger_DNY04";
    audioList = "SEL : male_wh_gunslinger_SEL01 male_wh_gunslinger_SEL02 male_wh_gunslinger_SEL03 male_wh_gunslinger_SEL04";
	
	//Effects
	addGameEffect = "combat sheriffscaredEffectronData 0 1 3.2 " @ $Detail::Medium;
	addGameEffect = "heal healingEffectronData 0 0 2 " @ $Detail::Medium;
	
	sightRange = 20;
};

// Tough Gunslinger
datablock SLGameObjData(Toughgunslinger)
{
   // SLGameObjData
   snapGrid = $SnapGrid::Detail;
   objTileOffset = "0 0";
   
   addCmpData = ToughMaleCharacterData;
   addCmpData = CombatAIData;
   addCmpData = CombatData_GunslingerTough;
   addCmpData = CombatCmdData;

  	shapeFile = "~/data/shapes/characters/toughgunslinger.dts";
  	
  	// health
   healthMax = 175;
   healthExtent = "49 12";
   healthScreenOffset = "0 0";
   healthWorldOffset = "0 0 4";
   healthImage = "~/client/ui/healthBar";
   healthBBoxHeight = false;

   // shadow for the object
	shadowDecal = DropShadowDecal;
	shadowScale = 1;
	shadowOffsetStatic = "0 0";
	shadowOffsetDynamic = "0 0.2";
	shadowAngleStatic = 0;
	shadowAngleDynamic = true;
	
	//Naming
	nameKey = "citizen_male_name";
	
   addIdle = "spintrick 3.8 revolver 2"; 
   addIdle = "portraitlook 3.5";  
   addIdle = "rocking 3.8";     
   addIdle = "spit 1.5";
   addIdle = "idle01 1.5";
   
   portraitImage = "assets/client/ui/hud/toughgunslinger_portrait";
	
	//audio
    audioList = "ACC : male_bh_gunslinger_ACC01 male_bh_gunslinger_ACC02 male_bh_gunslinger_ACC03 male_bh_gunslinger_ACC04";
    audioList = "ATT : male_bh_gunslinger_ATT01 male_bh_gunslinger_ATT02 male_bh_gunslinger_ATT03 male_bh_gunslinger_ATT04";
    audioList = "COM : male_bh_gunslinger_COM01 male_bh_gunslinger_COM02 male_bh_gunslinger_COM03 male_bh_gunslinger_COM04";
    audioList = "DIE : male_bh_gunslinger_DIE01 male_bh_gunslinger_DIE02 male_bh_gunslinger_DIE03 male_bh_gunslinger_DIE04";
    audioList = "DNY : male_bh_gunslinger_DNY01 male_bh_gunslinger_DNY02 male_bh_gunslinger_DNY03 male_bh_gunslinger_DNY04";
    audioList = "SEL : male_bh_gunslinger_SEL01 male_bh_gunslinger_SEL02 male_bh_gunslinger_SEL03 male_bh_gunslinger_SEL04";
	
	//Effects
	addGameEffect = "combat dualgun1EffectronData 0.6 2.5 2.6 " @ $Detail::Medium;
	addGameEffect = "combat dualgun2EffectronData -0.6 2 2.4 " @ $Detail::Medium;
	addGameEffect = "heal healingEffectronData 0 0 2 " @ $Detail::Medium;
	
	
	sightRange = 20;
};


// MR WONG
datablock SLGameObjData(MrWongData)
{
   // SLGameObjData
   snapGrid = $SnapGrid::Detail;
   objTileOffset = "0 0";
   
   addCmpData = MaleNotTownsfolkData;
   addCmpData = HeroAIData;
   addCmpData = CombatCmdData;
   addCmpData = CombatData_MrWhite;

  	shapeFile = "~/data/shapes/characters/mrwong.dts";
	addMount = "farmerhero_hat 0";

  	// health
   healthMax = 170;
   healthExtent = "49 12";
   healthScreenOffset = "0 0";
   healthWorldOffset = "0 0 4";
   healthImage = "~/client/ui/healthBar";
   healthBBoxHeight = false;
   healingRate = 16.0;
   
   // shadow for the object
	shadowDecal = DropShadowDecal;
	shadowScale = 1;
	shadowOffsetStatic = "0 0";
	shadowOffsetDynamic = "0 0.2";
	shadowAngleStatic = 0;
	shadowAngleDynamic = true;

	//Naming
	nameKey = "villain_mrwong_name";
	
	portraitImage = "assets/client/ui/hud/mrwong_portrait";
	
	portraitAnimations = "idle00 idle01 idle02 idle_look";
	portraitFocus = "idle00";
	portraitHappy = "idle01";
	portraitSad = "idle_look";
	
	sightRange = 20;
	
    audioList = "COM : wong_COM01 wong_COM02 wong_COM03";
    audioList = "DIE : wong_DIE01 wong_DIE02 wong_DIE03";
    audioList = "IHA : wong_IHA01 wong_IHA02 wong_IHA03";
    audioList = "SEL : wong_SEL01 wong_SEL02 wong_SEL03";
    
    //Effects
    addGameEffect = "combat sheriffshootEffectronData 0.8 3.6 2.7 " @ $Detail::High;
	
};

// MR WHITE
datablock SLGameObjData(MrWhiteData)
{
   // SLGameObjData
   snapGrid = $SnapGrid::Detail;
   objTileOffset = "0 0";
   
   addCmpData = MaleNotTownsfolkData;
   addCmpData = HeroAIData;
   addCmpData = CombatCmdData;
   addCmpData = CombatData_MrWhite;

  	shapeFile = "~/data/shapes/characters/mrwhite.dts";
	addMount = "farmerhero_hat 0";

  	// health
   healthMax = 170;
   healthExtent = "49 12";
   healthScreenOffset = "0 0";
   healthWorldOffset = "0 0 4";
   healthImage = "~/client/ui/healthBar";
   healthBBoxHeight = false;
   healingRate = 16.0;
   
   // shadow for the object
	shadowDecal = DropShadowDecal;
	shadowScale = 1;
	shadowOffsetStatic = "0 0";
	shadowOffsetDynamic = "0 0.2";
	shadowAngleStatic = 0;
	shadowAngleDynamic = true;

	//Naming
	nameKey = "villain_mrwhite_name";
	
	portraitImage = "assets/client/ui/hud/mrwhite_portrait";
	
	portraitAnimations = "idle00 idle01 idle02 idle_look";
	portraitFocus = "idle00";
	portraitHappy = "idle01";
	portraitSad = "idle_look";
	portraitImage = "assets/client/ui/hud/mrwhite_portrait";
	
	sightRange = 20;
	
    audioList = "COM : white_COM01 white_COM02 white_COM03";
    audioList = "DIE : white_DIE01 white_DIE02 white_DIE03";
    audioList = "IHA : white_IHA01 white_IHA02";
    audioList = "SEL : white_SEL01 white_SEL02 white_SEL03";
    
    //Effects
    addGameEffect = "combat sheriffshootEffectronData 0.8 3.6 2.7 " @ $Detail::High;
	
};

// MAD RUSSIAN
datablock SLGameObjData(MadRussianData)
{
   // SLGameObjData
   snapGrid = $SnapGrid::Detail;
   objTileOffset = "0 0";
   
   addCmpData = MaleNotTownsfolkData;
   addCmpData = HeroAIData;
   addCmpData = CombatCmdData;
   addCmpData = CombatData_MadRussian;

  	shapeFile = "~/data/shapes/characters/madrussian.dts";

  	// health
   healthMax = 200;
   healthExtent = "49 12";
   healthScreenOffset = "0 0";
   healthWorldOffset = "0 0 4";
   healthImage = "~/client/ui/healthBar";
   healthBBoxHeight = false;
   healingRate = 16.0;
   
   // shadow for the object
	shadowDecal = DropShadowDecal;
	shadowScale = 1;
	shadowOffsetStatic = "0 0";
	shadowOffsetDynamic = "0 0.2";
	shadowAngleStatic = 0;
	shadowAngleDynamic = true;

	//Naming
	nameKey = "villain_madrussian_name";
	
	portraitImage = "assets/client/ui/hud/madrussian_portrait";
	
	portraitAnimations = "idle00 idle01 idle02 idle_look";
	portraitFocus = "idle00";
	portraitHappy = "idle01";
	portraitSad = "idle_look";
	
	sightRange = 20;

    audioList = "COM : russian_COM01 russian_COM02 russian_COM03";
    audioList = "DIE : russian_DIE01 russian_DIE02 russian_DIE03";
    audioList = "IHA : russian_IHA01 russian_IHA02 russian_IHA03";
    audioList = "SEL : russian_SEL01 russian_SEL02 russian_SEL03";
    
    //Effects
    addGameEffect = "combat sheriffshootEffectronData 0.8 3.6 2.7 " @ $Detail::High;
    
};

// ----------- ENEMY COMBAT UNITS -----------
// Male bandit
datablock SLGameObjData(Malebandit)
{
   // SLGameObjData
   snapGrid = $SnapGrid::Detail;
   objTileOffset = "0 0";
   
   addCmpData = MaleNotTownsfolkData;
   addCmpData = BanditAIData;
   addCmpData = CombatData_BanditMale;

  	shapeFile = "~/data/shapes/characters/banditmale.dts";
  	addMount = "bandithat 0";
  	addMount = "bandana 3";
  	
  	// health
   healthMax = 130;
   healthExtent = "49 12";
   healthScreenOffset = "0 0";
   healthWorldOffset = "0 0 4";
   healthImage = "~/client/ui/healthBar";
   healthBBoxHeight = false;

   // shadow for the object
	shadowDecal = DropShadowDecal;
	shadowScale = 1;
	shadowOffsetStatic = "0 0";
	shadowOffsetDynamic = "0 0.2";
	shadowAngleStatic = 0;
	shadowAngleDynamic = true;
	
	//Naming
	nameKey = "citizen_male_name";
	
   addIdle = "spintrick 3.8 revolver 2"; 
   addIdle = "idle_look 3.4";   
   addIdle = "rocking 3.8";  
   addIdle = "shakefist 2.3"; 
   addIdle = "spit 1.5";
   
   portraitImage = "assets/client/ui/hud/banditmale_portrait";
	
	// Goodie death props
	deathPropMin = 0;
	deathPropMax = 1;
   deathProp = "goldbagpickup moneybagpickup";    
   deathLocation = "1 1";  
	
	//Effects
	addGameEffect = "combat dualgun1EffectronData 0.6 2.5 2.6 " @ $Detail::Medium;
	addGameEffect = "combat dualgun2EffectronData -0.6 2 2.4 " @ $Detail::Medium;
	
	sightRange = "20";

    audioList = "COM : m_bandit_COM01 m_bandit_COM02 m_bandit_COM03";
    audioList = "DIE : m_bandit_DIE01 m_bandit_DIE02 m_bandit_DIE03";
    audioList = "IHA : m_bandit_IHA01 m_bandit_IHA02 m_bandit_IHA03";
    audioList = "SEL : m_bandit_SEL01 m_bandit_SEL02 m_bandit_SEL03";
    
};

// Female bandit
datablock SLGameObjData(Femalebandit)
{
   // SLGameObjData
   snapGrid = $SnapGrid::Detail;
   objTileOffset = "0 0";
   
   addCmpData = FemaleNotTownsfolkData;
   addCmpData = BanditAIData;
   addCmpData = CombatData_BanditFemale;

  	shapeFile = "~/data/shapes/characters/banditfemale.dts";
  	addMount = "banditfemalehat 0";
  	addMount = "bandana 3";

  	// health
   healthMax = 130;
   healthExtent = "49 12";
   healthScreenOffset = "0 0";
   healthWorldOffset = "0 0 4";
   healthImage = "~/client/ui/healthBar";
   healthBBoxHeight = false;

   // shadow for the object
	shadowDecal = DropShadowDecal;
	shadowScale = 1;
	shadowOffsetStatic = "0 0";
	shadowOffsetDynamic = "0 0.2";
	shadowAngleStatic = 0;
	shadowAngleDynamic = true;
	
	//Naming
	nameKey = "citizen_female_name";
	
	addIdle = "shakefist 3.8";		
	addIdle = "portraitlook 3.8";
	addIdle = "spit 1.8";
	
	portraitImage = "assets/client/ui/hud/banditfemale_portrait";
	
	// Goodie death props
	deathPropMin = 0;
	deathPropMax = 1;
   deathProp = "goldbagpickup moneybagpickup";    
   deathLocation = "1 1";
	
	//effects
	addGameEffect = "combat sheriffshootEffectronData 0.7 3 2.7 " @ $Detail::Medium;
	
	sightRange = "20";

    audioList = "COM : f_bandit_COM01 f_bandit_COM02 f_bandit_COM03";
    audioList = "DIE : f_bandit_DIE01 f_bandit_DIE02 f_bandit_DIE03";
    audioList = "IHA : f_bandit_IHA01 f_bandit_IHA02 f_bandit_IHA03";
    audioList = "SEL : f_bandit_SEL01 f_bandit_SEL02 f_bandit_SEL03";
    
};
// ----------- ANIMALS ------------ 

// Rabbit
datablock SLGameObjData(Rabbit)
{
   // SLGameObjData
   snapGrid = $SnapGrid::Detail;
   objTileOffset = "0 0";
   
   addCmpData = TimidAnimalAIData;
   addCmpData = CombatData_Animal;

  	shapeFile = "~/data/shapes/characters/rabbit.dts";

   // health
   healthMax = 15;

	// Naming
	nameKey = "Rabbit";
	
	addIdle = "idle00 5";
   addIdle = "idle01 5";
   
   // Goodie death props
	deathPropMin = 1;
	deathPropMax = 1;
   deathProp = "meatpickup";    
   deathLocation = "0 0"; 
	
	sightRange = 12;
};

// Deer
datablock SLGameObjData(Deer : BasePortraitData)
{
   // SLGameObjData
   snapGrid = $SnapGrid::Detail;
   objTileOffset = "0 0";
   
   addCmpData = TimidAnimalAIData;
   addCmpData = CombatData_Animal;
   
  	shapeFile = "~/data/shapes/characters/deer.dts";

  	// health
   healthMax = 80;

	//Naming
	nameKey = "animal_deer_name";
	
	addIdle = "idle00 5";
   addIdle = "idle01 5";
   
   // Goodie death props
	deathPropMin = 0;
	deathPropMax = 1;
   deathProp = "meatpickup";    
   deathLocation = "0 0"; 
	
	sightRange = 17;
};
datablock SLGameObjData(TownDeer : BasePortraitData)
{
   // SLGameObjData
   snapGrid = $SnapGrid::Detail;
   objTileOffset = "0 0";
   
   addCmpData = FemaleNotTownsfolkData;
   addCmpData = CombatAIData;
   addCmpData = CombatData_Animal;
   
  	shapeFile = "~/data/shapes/characters/deer.dts";

  	// health
   healthMax = 100;

	//Naming
	nameKey = "animal_deer_name";
	
	addIdle = "idle00 5";
   addIdle = "idle01 5";
   
	sightRange = 17;
};

// Sasquatch
datablock SLGameObjData(Sasquatch : BasePortraitData)
{
   // SLGameObjData
   snapGrid = $SnapGrid::Detail;
   objTileOffset = "0 0";
   
   addCmpData = FemaleNotTownsfolkData;
   addCmpData = CombatFastAIData;
   addCmpData = CombatData_Sasquatch;

  	shapeFile = "~/data/shapes/characters/sasquatch.dts";

  	// health
   healthMax = 220;
   healthExtent = "49 12";
   healthScreenOffset = "0 0";
   healthWorldOffset = "0 0 6";
   healthImage = "~/client/ui/healthBar";
   healthBBoxHeight = false;

   // shadow for the object
	shadowDecal = DropShadowDecal;
	shadowScale = 1.2;
	shadowOffsetStatic = "0 0";
	shadowOffsetDynamic = "0 0.2";
	shadowAngleStatic = 0;
	shadowAngleDynamic = true;

   portraitOffset = "-.3 0 6.4";
   portraitRotation = "-20";
   portraitHeight = "10";
   portraitZoom = "12";
   portraitAngle = "15";
   portraitFOV = "12";
	
	// Audio Data
	audioList = "ATT : yeti_ATT01";
   audioList = "DIE : yeti_DIE01";
   audioList = "SBA : yeti_SBA01";
   audioList = "SEL : yeti_SEL01";
    
	//Naming
	nameKey = "animal_sasquatch_name";
	
	addIdle = "idle00 5";
   addIdle = "idle01 5";
	
	sightRange = 18;
};

// Bear
datablock SLGameObjData(Bear : BasePortraitData)
{
   // SLGameObjData
   snapGrid = $SnapGrid::Detail;
   objTileOffset = "0 0";
   
   addCmpData = TimidAnimalAIData;

  	shapeFile = "~/data/shapes/characters/bear.dts";

  	// health
   healthMax = 125;
	
	//Naming
	nameKey = "animal_bear_name";
	
	addIdle = "idle00 5";
	
	sightRange = 15;
};
// Town Bear
datablock SLGameObjData(TownBear : BasePortraitData)
{
   // SLGameObjData
   snapGrid = $SnapGrid::Detail;
   objTileOffset = "0 0";
   
   addCmpData = MaleNotTownsfolkData;
   addCmpData = CombatAIData;
   addCmpData = CombatData_Bear;

   shapeFile = "~/data/shapes/characters/bear.dts";

  	// health
   healthMax = 200;
   healthExtent = "49 12";
   healthScreenOffset = "0 0";
   healthWorldOffset = "0 0 4";
   healthImage = "~/client/ui/healthBar";
   healthBBoxHeight = false;
  	
  	// Audio Data
   audioList = "ATT : bear_ATT01";
   audioList = "DIE : bear_DIE01";
   audioList = "SBA : bear_SBA01";
   audioList = "SEL : bear_SEL01 bear_SEL02";  	
  	
	//Naming
	nameKey = "animal_bear_name";
	
	addIdle = "idle00 5";
	
	sightRange = 17;
};

// Horse
datablock SLGameObjData(Horse : BasePortraitData)
{
   // SLGameObjData
   snapGrid = $SnapGrid::Detail;
   objTileOffset = "0 0";
   
   shapeFile = "~/data/shapes/characters/horse.dts";

  	// health
   healthMax = 125;
   
   //Naming
	nameKey = "animal_horse_name";
	
	addIdle = "idle00 5";
   addIdle = "idle01 5";
	
};

// Horse Controllable
datablock SLGameObjData(HorseUnit : BasePortraitData)
{
   // SLGameObjData
   snapGrid = $SnapGrid::Detail;
   objTileOffset = "0 0";
   
   addCmpData = MaleNotTownsfolkData;
   addCmpData = CombatAIData;


  	shapeFile = "~/data/shapes/characters/horse.dts";

  	// health
   healthMax = 125;

   portraitOffset = "-.3 0 7.6";
   portraitRotation = "-30";
   portraitHeight = "10";
   portraitZoom = "16";
   portraitAngle = "5";
   portraitFOV = "12";

	//Naming
	nameKey = "animal_horse_name";
};

// Engine Placeholder
datablock SLGameObjData(Engine : BasePortraitData)
{
   // SLGameObjData
   snapGrid = $SnapGrid::Detail;
   objTileOffset = "0 0";

  	shapeFile = "~/data/shapes/characters/engine.dts";
  	
  	//effects
   addGameEffect = "train smokeEffectronData 3.8 0 7 " @ $Detail::High;
   
  	// health
   healthMax = 125;
};

// Coalcar Placeholder
datablock SLGameObjData(Coalcar)
{
   // SLGameObjData
   snapGrid = $SnapGrid::Detail;
   objTileOffset = "0 0";

  	shapeFile = "~/data/shapes/characters/coalcar.dts";

  	// health
   healthMax = 125;

	//Naming
	nameKey = "citizen_male_name";
};

// Car One Placeholder
datablock SLGameObjData(Carone)
{
   // SLGameObjData
   snapGrid = $SnapGrid::Detail;
   objTileOffset = "0 0";

  	shapeFile = "~/data/shapes/characters/carone.dts";

  	// health
   healthMax = 125;

};

// Car Two Placeholder
datablock SLGameObjData(Cartwo)
{
   // SLGameObjData
   snapGrid = $SnapGrid::Detail;
   objTileOffset = "0 0";

  	shapeFile = "~/data/shapes/characters/cartwo.dts";

  	// health
   healthMax = 125;

};


// Log Car Placeholder
datablock SLGameObjData(Logcar)
{
   // SLGameObjData
   snapGrid = $SnapGrid::Detail;
   objTileOffset = "0 0";

  	shapeFile = "~/data/shapes/characters/logcar.dts";


};

// Wagon Placeholder
datablock SLGameObjData(Wagon : BasePortraitData)
{
   // SLGameObjData
   snapGrid = $SnapGrid::Detail;
   objTileOffset = "0 0";

  	shapeFile = "~/data/shapes/characters/wagon.dts";
  	addMount = "wagondude 0";
  	addMount = "pannerhatwagon 1";
  	addMount = "shotgun 2";

};

// Horses
datablock SLGameObjData(Horses : BasePortraitData)
{
   // SLGameObjData
   snapGrid = $SnapGrid::Detail;
   objTileOffset = "0 0";

  	shapeFile = "~/data/shapes/characters/horses.dts";
  	addMount = "yoke 0";
  	addMount = "yoke2 1";

};  

// Wagon Bar
datablock SLGameObjData(Bar)
{
   // SLGameObjData
   snapGrid = $SnapGrid::Detail;
   objTileOffset = "0 0";

  	shapeFile = "~/data/shapes/characters/bar.dts";
};
